﻿var responsesLogs = {
    context: $(".v-responsesLogs"),
    datatable: null,
    respondentId: $("#RespondentId").val(),
    initialize: function () {
        var columns = [
            { "Name": "Variable", "Title": resources.Variable, "Data": "Variable" },
            { "Name": "Row", "Title": resources.Row, "Data": "Row" },
            { "Name": "Mention", "Title": resources.Mention, "Data": "Mention" },
            { "Name": "Source", "Title": resources.Source, "Data": "SourceEnum", "Type": "enum", "EnumType": "ResponseSourceType" },
            { "Name": "Content", "Title": resources.Answer, "Data": "Answer", "EncodeHtml": true },
            { "Name": "OpenEnd", "Title": resources.OpenEnd, "Data": "OpenEnd", "Sortable": false, "EncodeHtml": true },
            { "Name": "PreviousContent", "Title": resources.PreviousAnswer, "Data": "PreviousAnswer", "EncodeHtml": true },
            { "Name": "PreviousOpenEnd", "Title": resources.PreviousOpenEnd, "Data": "PreviousOpenEnd", "Sortable": false, "EncodeHtml": true },
            { "Name": "ModifiedBy", "Title": resources.ModifiedBy, "Data": "ModifiedBy", },
            { "Name": "Modified", "Title": resources.Modified, "Data": "Modified", "Type": "date" }
        ];


        this.datatable = $(".h-responsesLogsTable", this.context).a4datatable({
            generateTableStructure: true,
            displayColumnSelector: true,
            advancedFilter: true,
            ajaxAction: a4.getSurveyAction("GetResponsesLogs", "Analyze"),
            ajaxParams: { "respondentId": responsesLogs.respondentId },
            columns: columns,
            saveState: true,
            stateKey: "ResponsesLogs",
            toolBarItems: [{ "Action": "export", "Label": resources.Export, "DisplayMode": dataTables.itemDisplayMode.always }],
            toolBarClick: function (event, data) {
                var action = data.action;

                switch (action) {
                    case "export":
                        var columns = responsesLogs.datatable.a4datatable("getVisibleColumns");
                        var tableParams = responsesLogs.datatable.a4datatable("getTableParams");

                        var link = a4.getSurveyAction("ExportResponsesLogs", "Analyze", { tableParams: JSON.stringify(tableParams), filter: JSON.stringify(respondents.respondentFilter), columns: columns.join(), respondentId: responsesLogs.respondentId });

                        respondents.exportFile(link, {}, "GetResponsesLogsExportFile");
                        break;
                }
            }
        });
    },
    refreshContent: function () {
        this.datatable.a4datatable("refresh");
    }
};

$(document).ready(function () {
    if (responsesLogs.context.length > 0) {
        responsesLogs.initialize();
    }
});